/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse vec4(0.0,0.0, 0.0,0.0)

/////////////////////////////////////////////////////////////////////////////////

const float duration = 2.2;

const int maxIter = 8;
const float lineWidth = 0.004;

const vec3 red = vec3(0.7, 0.0, 0.0);
const vec3 yellow = vec3(0.9, 0.8, 0.0);
const vec3 blue = vec3(0.2, 0.2, 0.8);



float hash11(float p) {
    vec2 p2 = fract(p * vec2(443.8975, 397.2973));
    p2 += dot(p2.xy, p2.yx + 19.19);
    return fract(p2.x * p2.y);
}

float hash13(vec3 p) {
	p  = fract(p * vec3(443.8975, 397.2973, 491.1871));
    p += dot(p.xyz, p.yzx + 19.19);
    return fract(p.x * p.y * p.z);
}

vec2 hash21(float p) {
    vec3 p3 = fract(p * vec3(443.8975, 397.2973, 491.1871));
    p3 += dot(p3.xyz, p3.yzx + 19.19);
    return fract(vec2(p3.x * p3.y, p3.z * p3.x));
}

void main( void ) {
    vec2 pos = gl_FragCoord.xy / iResolution.x;
   	float screenHeight = iResolution.y / iResolution.x;
    float pixelWidth = lineWidth + 1.0 / iResolution.x;
    
    vec2 cellMin = vec2(lineWidth, lineWidth);
    vec2 cellMax = vec2(1.0 - lineWidth, screenHeight - lineWidth);
    float cellID = floor(iGlobalTime / duration);
    float t = mod(iGlobalTime / duration, 1.0);
    
    vec2 imageDetailBias = vec2(0.1 + 0.5 * hash11(cellID + 0.9));
    //vec2 imageDetailBias = vec2(0.1) + 0.5 * hash21(cellID + 0.9);
    float imageColorBias = 0.25 + 0.5 * hash11(cellID + 0.8);
    
    for (int i = 0; i < maxIter; ++i) {
        vec2 cellSize = cellMax - cellMin;
        vec2 split = floor(2.0 * pow(cellSize, imageDetailBias) * hash21(cellID));
        
        vec2 cellDiv = vec2(0.2) + 0.6 * hash21(cellID + 0.1);
        cellDiv = cellMin + split * cellDiv * cellSize;
        
        vec2 child = step(cellDiv, pos);
        
        cellMin = mix(cellMin, cellDiv, child);
        cellMax = mix(cellDiv, cellMax, child);
        cellID = hash13(vec3(cellID, child));
    }
    
    vec3 color;
    float cell = hash11(cellID) / imageColorBias;
    if (cell < 0.2)
        color = red;
    else if (cell < 0.4)
        color = yellow;
    else if (cell < 0.6)
        color = blue;
    else if (cell < 0.64)
        color = vec3(0.0);
    else
        color = vec3(1.0);
        
    color *= step(cellMin.x + lineWidth, pos.x) * step(pos.x, cellMax.x - lineWidth);
    color *= step(cellMin.y + lineWidth, pos.y) * step(pos.y, cellMax.y - lineWidth);
        
    color *= smoothstep(0.0, 0.1, t) * smoothstep(1.0, 0.9, t);
    
	gl_FragColor = vec4(color, 1.0);
}